package gov.va.genisis2.dao.impl;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import gov.va.genisis2.dao.IUserTypeDao;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.UserType;

/**
 *
 * The UserType data access object (DAO) is an object that provides an abstract
 * interface to some type of database or other persistence mechanism. By mapping
 * application calls to the persistence layer, UserType DAO provide some
 * specific data operations without exposing details of the database.
 * 
 * @author PII
 *
 */
@Repository
@Transactional(value = "transactionManager")
public class UserTypeDao extends AbstactHibernateDao implements IUserTypeDao {

	private static final Logger LOGGER = LoggerFactory.getLogger(UserTypeDao.class);

	@Autowired
	private SessionFactory sessionFactory;

	@Override
	@Cacheable(value = "getUserType", key = "#id")
	public UserType getUserType(int id) throws GenisisDAOException {
		UserType userType = null;
		try {
			Session session = sessionFactory.getCurrentSession();
			userType = session.get(UserType.class, id);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred while querying getUserType.", ex);
			throw new GenisisDAOException("Exception occurred while querying getUserType.", ex);
		}
		return userType;
	}

	/**
	 * @param sessionFactory
	 *            the sessionFactory to set
	 */
	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}

}
